/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWScenarioTime;
import filenet.sim.api.VWScenarioTimeType;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.IFieldCollection;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public final class VWScenarioTimeDuration
implements IVWScenarioTime,
Serializable,
Cloneable {
    private String m_duration = null;
    private int m_units;
    private Date m_absoluteBaseTime = null;
    private int m_calculatedDuration = 0;
    private boolean m_isValid = false;

    public VWScenarioTimeDuration(String duration, int units) throws VWException {
        this.setDuration(duration);
        this.setUnits(units);
    }

    public String getDuration() {
        return this.m_duration;
    }

    public void setDuration(String duration) throws VWException {
        this.m_duration = duration;
    }

    public int getUnits() {
        return this.m_units;
    }

    public void setUnits(int units) {
        this.m_units = units;
    }

    public void validate(Date absoluteBaseTime, int validationType, String objectName, String workflowName, String mapName, Integer stepId, IFieldCollection mainFields, IFieldCollection inheritedFields, Vector EDefVector) throws VWException {
        VWCompiledExpr compRes;
        this.m_absoluteBaseTime = absoluteBaseTime;
        String expression = this.getDuration();
        String[] theErrorStrings = VWExpr.compileVWExpr(expression, mainFields, inheritedFields, null, null, mainFields != null, compRes = new VWCompiledExpr());
        if (theErrorStrings != null) {
            this.m_isValid = false;
            int errorCount = theErrorStrings.length;
            for (int j = 0; j < errorCount; ++j) {
                VWString theMessage = new VWString("sim.api.VWScenarioTimeType.TimeExpressionSyntaxError", "Syntax error in time expression: {0}", theErrorStrings[j]);
                VWScenarioValidationError theError = new VWScenarioValidationError(validationType, 1, objectName, expression, theMessage.toString(), workflowName, mapName, stepId != null ? stepId : -1);
                EDefVector.addElement(theError);
            }
        } else if (compRes.getResultIsArray() || compRes.getResultType() != 1 && compRes.getResultType() != 8) {
            this.m_isValid = false;
            VWString theMessage = new VWString("sim.api.VWScenarioTimeType.TimeExpressionWrongType", "Invalid time expression. Time expression should evalute to type {0}.", VWFieldType.getLocalizedString(1));
            VWScenarioValidationError theError = new VWScenarioValidationError(validationType, 1, objectName, expression, theMessage.toString(), workflowName, mapName, stepId != null ? stepId : -1);
            EDefVector.addElement(theError);
        } else if (this.m_absoluteBaseTime != null) {
            this.m_calculatedDuration = (Integer)compRes.execute(mainFields, inheritedFields, null);
            this.m_isValid = true;
        }
    }

    public Date getAbsoluteTime() throws VWException {
        if (!this.m_isValid || this.m_absoluteBaseTime == null) {
            return null;
        }
        GregorianCalendar time = new GregorianCalendar();
        time.setTime(this.m_absoluteBaseTime);
        VWScenarioTimeType.addUnitsToTime(time, this.getUnits(), this.m_calculatedDuration);
        return time.getTime();
    }

    protected Object clone() {
        VWScenarioTimeDuration clone = null;
        try {
            clone = (VWScenarioTimeDuration)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

